'use strict';

/* Controllers */
var BankCtrl = ['$scope', '$rootScope', '$location', '$route', '$window', 'FrontCreatorBankServices', function($scope, $rootScope, $location, $route, $window, FrontCreatorBankServices){
    var myPlayerName = "creator_bank";
    var myPlayer = _V_(myPlayerName);
    var addCuepointForVideojs = true;

    $rootScope.$on('Tutorial:open', function(event, type){
        myPlayer.pause();
    });

    $scope.CreatorStage = $route.current.locals.creatorStage;
    $scope.bankServices = $route.current.locals.bankServices;
    $scope.Company = $route.current.locals.company;
    $scope.usersList = {};//$route.current.locals.company.user_groups.users;

    $scope.bankServiceMandatorySymbols = ['CURRENT_ACCOUNT'];
    $scope.checkedBankServiceTypes = [];
    $scope.currentPoint = {};
    $scope.errorValue = false;
    $scope.toHighValue = false;
    $scope.indexTokenPart = 6;
    $scope.methodType = 'creator-bank';
    $scope.newInvestmentValue = {};

    $scope.stageDone = false;

    $scope.init = function() {
        var state = $scope.Company.creator_state;
        if(state == 4 || state == 5 || state == 6 || state == 7){
            $scope.stageDone = true;
        }

        $('#wrap').removeClass('start-page');
        var partListPlayFalse = [3,4];  //2 - mandatory
        angular.forEach($scope.CreatorStage.parts, function(part) {
            part.play = (in_array(part.index, partListPlayFalse)) ? false : true;
            part.hide = false;
        });

        var active = true;
        angular.forEach($scope.CreatorStage.steps, function(step) {
            step.active =  active;
            active = false;
        });

        $scope.updateCheckedBankServiceTypes();

        angular.forEach($scope.Company.user_groups.users, function(user) {
            user.fullName = user.name+' '+user.surname;
            user.token = '';
            $scope.usersList[user.id] = user;
        });

        angular.forEach($scope.getBankServiceOptions('INVESTMENT'), function(option) {
            if(!option.value){
                option.value = 1;
            }
        });

        $scope.addCuepointForVideojs();
    }

    $scope.addCuepointForVideojs = function(){
        if(addCuepointForVideojs) {
            videojs(myPlayerName).ready(function(){
                var $this = this;
                $this.cuepoints();
                angular.forEach($scope.CreatorStage.parts, function(part){
                    $this.addCuepoint({
                        namespace: "logger",
                        start: part.end,
                        end: part.end + 0.3,
                        onStart: function(params){
                            if(params.error){
                            }else{
                                myPlayer.pause();
                                hiddenControlVideo();
                                $rootScope.$broadcast('DialogPanelBank:show', part);
                                //$(".nano").nanoScroller();
                            }
                        },
                        onEnd: function(params){
                            myPlayer.play();
                        },
                        params: {error: false}
                    });
                });
            });
            addCuepointForVideojs = false;
            myPlayer.ready(function(){
                this.on("ended", function(){
                    $location.path('/creator/officeKRS');
                });
            });
        }
    }

    $scope.$on('DialogPanelBank:show', function(event, part){
        $scope.currentPoint = part;
        $scope.$apply();
        if($scope.currentPoint.index == $scope.indexTokenPart ) {
            $scope.broadcast();
        }
    });

    $scope.$on('Tokens:closeSubmitTokensModal', function(event,methodType){
        if(methodType == $scope.methodType) {
            $scope.playVideo();
        }
    });

    $scope.updateCheckedBankServiceTypes = function(){
        $scope.checkedBankServiceTypes = [];
        angular.forEach($scope.bankServices, function(BankService) {
            BankService.checked =  (in_array(BankService.symbol,$scope.bankServiceMandatorySymbols)) ? true : false;
            angular.forEach(BankService.types, function(BankServiceOption) {
                var checked = false;
                BankServiceOption.value = '';
                angular.forEach($scope.Company.bank_service_options, function(CompanyBankServiceOption, index) {
                    if(BankServiceOption.id == CompanyBankServiceOption.option.id){
                        BankServiceOption.value = BankServiceOption.oldValue = CompanyBankServiceOption.value;
                        $scope.checkedBankServiceTypes.push(CompanyBankServiceOption);
                        checked = true;
                        BankService.checked = true;
                    }
                });
                BankServiceOption.checked = checked;
            });
        });
    }

    $scope.resetVideo = function(){
        myPlayer.currentTime(0);
        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.submitForm = function(form) {
        if (form == undefined || form.$valid) {
            $scope.playVideo();
        } else {
            $scope.showValidation = form.$invalid;
        }
    }

    $scope.submitFormOption = function(form, serviceType) {
        $scope.errorValue = false;
        angular.forEach($scope.getBankServiceOptions(serviceType), function(option){
            if(option.is_value && option.checked && (option.value === undefined || option.value === '' || option.value === null || option.value <= 0)) {
                $scope.errorValue = true;
            }
            else
            {
                angular.forEach($scope.checkedBankServiceTypes, function(checkedOption){
                    if(checkedOption.option.id == option.id){
                        checkedOption.value = option.value;
                    }
                });
            }
        });

        if (form == undefined || (form.$valid && !$scope.errorValue && !$scope.toHighValue)) {
            $scope.setValueForRB($scope.getValueForRB());
            FrontCreatorBankServices.saveOptions({during_creator: true, checkedBankServiceTypes: $scope.checkedBankServiceTypes},
                function(data){
                    $scope.Company = data;
                    $scope.playVideo();
                    $scope.updateCheckedBankServiceTypes();
                    $scope.newInvestmentValue = {};
                },
                function(data){
                    var message = {
                        title: "Błąd kreatora."
                        ,msg: data.data.message
                    }

                    $rootScope.$broadcast('Message:addMsg', message);
                    setTimeout(function(){
                        $rootScope.$broadcast('Message:delMsg', message);
                        setTimeout(function(){
                            $window.location.reload()
//                        $location.path('/boardControlPanel/personnel');
                        }, 500);
                    }, 4000);
                }
            );
        } else {
            $scope.showValidation = ($scope.errorValue) ? true : form.$invalid;
        }
    }

    $scope.playVideo = function(){
        if($scope.currentPoint.step_index > 0){
            angular.forEach($scope.CreatorStage.steps, function(step){
                if(step.index == $scope.currentPoint.step_index){
                    step.done = true;
                    step.active = true;
                } else {
                    step.active = false;
                }
            });
        }

        var nextPoint = getNextPoint($scope.currentPoint);
        if(nextPoint.hasOwnProperty('id') && !nextPoint.play) {
            myPlayer.currentTime(nextPoint.end+0.4);
            $scope.currentPoint = nextPoint;
            $scope.submitForm();
        }

        $scope.currentPoint = {};
        $scope.showValidation = false;
        showControlVideo();
        myPlayer.play();
    }

    $scope.showPanel = function($index){
        return ($scope.currentPoint.hasOwnProperty('id') && ($index == $scope.currentPoint.index));
    }

    $scope.isSelectedPanel = function(){
        return ($scope.currentPoint.hasOwnProperty('id'));
    }

    $scope.getBankServiceOptions = function(symbol) {
        var bankService;
        angular.forEach($scope.bankServices, function(service){
            if(service.symbol == symbol) {
                bankService = service;
            }
        });
        return bankService.types;
    }

    $scope.checkServiceType = function(service) {
        if(!in_array(service.symbol, $scope.bankServiceMandatorySymbols)) {
            if(service.symbol == 'CURRENT_ACCOUNT'){
                service.checked = true;
            }else{
                service.checked = !service.checked;                
            }
            angular.forEach($scope.CreatorStage.parts, function(part){
                if(part.index == service.step_index) {
                    part.play = service.checked;
                }
            });
        }
    }

    $scope.checkServiceOption = function(option, serviceType) {
        if(serviceType == 'REVOLVING_LOAN'){
            angular.forEach($scope.getBankServiceOptions('REVOLVING_LOAN'), function(creditOption){
                if(creditOption.id != option.id) {
                    creditOption.checked = false;
                    $scope.removeOption(creditOption);
                }
            });
        }
        option.checked = !option.checked;

        if(serviceType == 'CURRENT_ACCOUNT'){
            angular.forEach($scope.getBankServiceOptions('CURRENT_ACCOUNT'), function(creditOption){
                if(creditOption.id != option.id) {
                    creditOption.checked = false;
                    $scope.removeOption(creditOption);
                }
                else
                {
                    option.checked = true;
                }
            });
        }

        if(option.checked) {
            $scope.checkedBankServiceTypes.push({value: option.value ? option.value : 0, option: option});
        } else {
            option.value = 1;
            $scope.changeValue(option);
            $scope.removeOption(option);
        }
    }

    $scope.removeOption = function(option) {
        angular.forEach($scope.checkedBankServiceTypes, function(checkedBankServiceType, index){
            if(checkedBankServiceType.option.id == option.id) {
                if(option.oldValue && checkedBankServiceType.option.bank_service){
                    var currentAccount = 0;
                    var flagRB = 'RB';

                    angular.forEach($scope.checkedBankServiceTypes, function(checkedOption){
                        if(checkedOption.option.flags && in_array(flagRB, checkedOption.option.flags.split(","))){
                            checkedOption.value += option.oldValue;
                        }
                    });          
                }

                $scope.checkedBankServiceTypes.splice(index,1);
                delete $scope.newInvestmentValue[option.id];
            }
        });
    }

    $scope.broadcast = function() {
        var params = {};
        params.title = 'Podpisanie umowy bankowej';
        params.tokensConfirmsMessage = 'creator,'+$scope.CreatorStage.symbol;
        params.typeSubmitToken = 'REPRESENTATION';

        $rootScope.$broadcast('Tokens:openSubmitTokensModal',$scope.Company, params, $scope.methodType);
    }

    $scope.getDate = function(){
        return new Date();
    }

    $scope.isCredit = function(){
        return ($scope.getCredit()) ? true : false;
    }

    $scope.getCredit = function()
    {
        var credit = false;
        angular.forEach($scope.Company.bank_service_options, function(companyOption){
            if(typeof companyOption.option.bank_service != 'undefined' && companyOption.option.bank_service.symbol == 'REVOLVING_LOAN')
            {
                credit = companyOption;
            }
        });
//        console.log(credit);
        return credit;
    }

    $scope.getValueForRB = function(){
        var value = 0;
        angular.forEach($scope.checkedBankServiceTypes, function(checkedOption){
            if(typeof checkedOption.option.bank_service != 'undefined' && (checkedOption.option.bank_service.symbol == 'CURRENT_ACCOUNT' || checkedOption.option.bank_service.symbol == 'REVOLVING_LOAN'))
            {
                value += checkedOption.init_value;
            }
        });

//        angular.forEach($scope.newInvestmentValue, function(newValue){
//            if(Number(newValue) <= value){
//                value -= Number(newValue);
//            }else{
//                value = -1;
//                return value;
//            }
//        });

        return parseFloat(value);
    }

    $scope.setValueForRB = function($value){
        angular.forEach($scope.checkedBankServiceTypes, function(checkedOption){
            if(typeof checkedOption.option.bank_service != 'undefined' && checkedOption.option.bank_service.symbol == 'CURRENT_ACCOUNT')
            {
//                checkedOption.value = $value;
            }
        });
    }

    $scope.changeValue = function(option){
        $scope.newInvestmentValue[option.id] = Number(option.value) - (option.oldValue ? Number(option.oldValue) : 0);
    }

    $scope.checkCurrentAccount = function(option){
        option.checked = true;
    }

    $scope.changeInvestmentValue = function(option){
        $scope.changeValue(option);

        $scope.toHighValue = false;
        var currentAccount = $scope.getValueForRB();

        if(currentAccount < 0)
        {
            $scope.toHighValue = true;
            formBankInvestmentType.$valid = false;
        }
        else
        {
            if(formBankInvestmentType.$invalid == false)
            {
                formBankInvestmentType.$valid = true;
            }
            $scope.toHighValue = false;
        }

    }

    $scope.nameNumber = function(number) {
        var jednosci = ["", " jeden", " dwa", " trzy", " cztery", " pięć", " sześć", " siedem", " osiem", " dziewięć"];
        var nascie = ["", " jedenaście", " dwanaście", " trzynaście", " czternaście", " piętnaście", " szesnaście", " siedemnaście", " osiemnaście", " dziewietnaście"];
        var dziesiatki = ["", " dziesięć", " dwadzieścia", " trzydzieści", " czterdzieści", " pięćdziesiąt", " sześćdziesiąt", " siedemdziesiąt", " osiemdziesiąt", " dziewięćdziesiąt"];
        var setki = ["", " sto", " dwieście", " trzysta", " czterysta", " pięćset", " sześćset", " siedemset", " osiemset", " dziewięćset"];
        var grupy = [["" ,"" ,""],[" tysiąc" ," tysiące" ," tysięcy"],[" milion" ," miliony" ," milionów"],[" miliard"," miliardy"," miliardów"],[" bilion" ," biliony" ," bilionów"],[" biliard"," biliardy"," biliardów"],[" trylion"," tryliony"," tryliardów"]];

        if (!isNaN(number)){
            var wynik = '';
            var znak = '';
            if (number == 0) wynik = "zero";
            if (number < 0) {
                znak = "minus";
                number = number;
            }

            var g = 0;
            while (number > 0) {
                var s = Math.floor((number % 1000)/100);
                var n = 0;
                var d = Math.floor((number % 100)/10);
                var j = Math.floor(number % 10);
                if (d == 1 && j>0) {
                    n = j;
                    d = 0;
                    j = 0;
                }

                var k = 2;
                if (j == 1 && s+d+n == 0)
                    k = 0;
                if (j == 2 || j == 3 || j == 4)
                    k = 1;
                if (s+d+n+j > 0)
                    wynik = setki[s]+dziesiatki[d]+nascie[n]+jednosci[j]+grupy[g][k]+wynik;

                g++;
                number = Math.floor(number/1000);
            }
        }
        return wynik;
    }

    function getNextPoint(point) {
        if(!point) return $scope.CreatorStage.parts[0];
        var nextPoint = {};
        angular.forEach($scope.CreatorStage.parts, function(part, index){
            if(part.id == point.id) {
                nextPoint = ($scope.CreatorStage.parts[index+1] === undefined) ? {} : $scope.CreatorStage.parts[index+1];
            }
        });
        return nextPoint;
    }

    function hiddenControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","hidden");
        $($('.vjs-progress-control').first()).css("visibility","hidden");
    }

    function showControlVideo() {
        $($('.vjs-play-control').first()).css("visibility","");
        $($('.vjs-progress-control').first()).css("visibility","");
    }

    function in_array(needle, haystack) {
        for(var i in haystack) {
            if(haystack[i] == needle) return true;
        }
        return false;
    }

    /**
     * NOWE FUNKCJE
     */
    $scope.validation = [];
    $scope.validateInvestment = function(formBankInvestmentType){
        $scope.validation = [];
        var options = $scope.getBankServiceOptions('INVESTMENT');
        var numberOfChecked = 0;
        var sum = 0;

        var currentAccountValue = $scope.getValueForRB();

        options.forEach(function(option){
            if(option.checked)
            {
                numberOfChecked++;
                sum += parseFloat(option.value);
                if(option.value <= 0)
                {
                    $scope.validation.push('Wartość lokaty ' + option.name + ' nie może być mniejsza od 0');
                }
            }
        });

        if(numberOfChecked == 0)
        {
            return false;
        }

        if(currentAccountValue < sum)
        {
            $scope.validation.push('Suma lokat wyższa niż ilość dostepnych środków na koncie');
        }

        if($scope.validation.length > 0)
        {
            formBankInvestmentType.$valid = false;
            return false;
        }
        formBankInvestmentType.$valid = true;
        return true;
    }


    $scope.getCurrentAccountValue = function(){
        var currentAccountValue = $scope.getValueForRB();
        var options = $scope.getBankServiceOptions('INVESTMENT');
        var sum = 0;

        options.forEach(function(option){
            if(option.checked && option.value)
            {
                sum += parseFloat(option.value);
            }
        });

        return currentAccountValue - sum;
    }

    $scope.validationsRevolvingLoan = [];
    $scope.validateRevolvingLoan = function(formBankCreditType){
        formBankCreditType.$valid = true;
        $scope.validationsRevolvingLoan = [];

        var options = $scope.getBankServiceOptions('REVOLVING_LOAN');
        var isChecked = false;
        var value = 0;

        for(var i = 0; i < options.length; i++)
        {
            if(options[i].checked)
            {
                isChecked = true;
                value = options[i].value;
            }
        }

        if(!isChecked || value > 5000000)
        {
            formBankCreditType.$valid = false;
            $scope.validationsRevolvingLoan.push('Zbyt wysoka wartość kredytu obrotowego lub nie został wybrany żaden kredyt');
            return false;
        }

        if(value <= 0)
        {
            formBankCreditType.$valid = false;
            $scope.validationsRevolvingLoan.push('Wartość kredytu obrotowego musi byc większa od 0');
            return false;
        }

        return true;
    }



}]

BankCtrl.getCreatorStage = function($q, $route, $rootScope, FrontCreatorStage){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorStage.get({symbol: "BANK"},function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}

BankCtrl.getBankServices = function($q, $route, $rootScope, FrontCreatorBankServices){
    $rootScope.incLoading();
    var defer = $q.defer();
    FrontCreatorBankServices.get(function(data){
        $rootScope.decLoading();
        defer.resolve(data)
    }, ErrorCtrl.showError);

    return defer.promise;
}